#ifndef __EXPR_OPR__
#define __EXPR_OPR__

#include "expr.h"

typedef struct expr_opr {
    refobj_t ref;   //first part is the same as expr_t
    int    ( *eval  )(struct expr *self);
    void   ( *print )(struct expr *self);

    int (*fp_opr)(int a, int b); //operator function
    char *str_opr;      //operator string
    struct expr *a;     //operand 1
    struct expr *b;     //operand 2
} expr_opr_t;

//common functions for binary operators
//
extern int  expr_eval_opr(expr_t *self);
extern void expr_print_opr(expr_t *self);
extern void expr_release_opr(refobj_t *ref);
extern expr_t *expr_make_opr(expr_t *a, expr_t *b, char *str_opr, int (*fp_opr)(int a, int b));
#endif
