//
// expr_arith.c
//  arithmetic operators
//

#include "expr.h"
#include "expr_opr.h"

//add
//
static int int_add(int a, int b) {
    return a + b;
}
expr_t *expr_make_add(expr_t *a, expr_t *b) {
    return expr_make_opr(a, b, "+", int_add);
}

//sub
//
static int int_sub(int a, int b) {
    return a - b;
}
expr_t *expr_make_sub(expr_t *a, expr_t *b) {
    return expr_make_opr(a, b, "-", int_sub);
}

//mul
//
static int int_mul(int a, int b) {
    return a * b;
}
expr_t *expr_make_mul(expr_t *a, expr_t *b) {
    return expr_make_opr(a, b, "*", int_mul);
}

//div
//
static int int_div(int a, int b) {
    return a / b;
}
expr_t *expr_make_div(expr_t *a, expr_t *b) {
    return expr_make_opr(a, b, "/", int_div);
}
